﻿<%@ Control Language="C#" AutoEventWireup="true" CodeFile="ucOutcomeMeasures.ascx.cs" Inherits="ucOutcomeMeasures" %>
<%@ Register TagPrefix="ucTBICDS" TagName="EventEntry" Src="ucEventEntry.ascx" %>
<%@ Register TagPrefix="ucTBICDS" TagName="TrendGraph" Src="ucTrendGraph.ascx" %>

<script type="text/javascript">

    function AriaOMReviewButton(el)
    {
        el.set({
            "role": 'button'
        });
    }

    function AriaOMTrendButton(el)
    {
        el.set({
            "role": 'button'
        });
    }

    //hide edit options for tree rows as needed
    var UCOMPrepareCommand = function (grid, command, record, row) {
        if (record.get('pw_event_module_id') == '-1') {
            command.hidden = true;
            command.hideMode = 'visibility'; //you can try 'display' also  
        }
        else {
            if (command.command == 'CMD_UCOM_REVIEW' && record.get('pw_event_module_id') < 1) {
                command.disabled = true;
            }

            if (command.command == 'CMD_UCOM_REVIEW' && record.get('event_status') == 2) {
                command.disabled = true;
            }
        }
    };

    //grid panel command handlers for buttons in the grid 
    var OnUCOMReviewCommand = function (command, strStoreRow) {
        switch (command) {
            case "CMD_UCOM_REVIEW":
                App.direct.UCOUTCOMES.OnReviewCommand(strStoreRow);
                break;
        }
    }

    //grid panel command handlers for buttons in the grid 
    var OnTrendCommand = function (command, strStoreRow) {
        var filter = 0, /*0 = get all trend*/
            highlight = '';

        /*filter*/
        if (strStoreRow.event_status == 2) {
            filter = 1;
        }

        /*subscale*/
        if(strStoreRow.pw_event_module_id == -1) {
            highlight = strStoreRow.module;
        }

        switch (command) {
            case "CMD_SHOW_TREND":
                ucTrendGraphJS.show(strStoreRow.patient_id, strStoreRow.mid, strStoreRow.intake_id, filter, highlight);
                break;
        }
    }

</script>

<%--Trend Graph User Control Control--%>
<ucTBICDS:TrendGraph ID="ucTrendGraph" runat="server" />

<ext:Panel ID="fpnlUCOutcomes"
    Margin="0"
    Border="false"
    runat="server"
    Visible="true" 
    AnchorHorizontal="100%" 
    AnchorVertical="100%"
    Layout="BorderLayout" BodyCls="background-color: #fff;">
    <Items>
        <ext:TreePanel
            ID="tpnlUCOM"
            runat="server"
            Title="Outcomes"
            Padding="0"
            Border="false"
            Collapsible="false"
            UseArrows="true"
            RootVisible="false"
            MultiSelect="true"
            SingleExpand="false"
            SortableColumns="false"
            FolderSort="false"
            IDMode="Static"
            Region="North"
            Flex="1"
            Layout="FitLayout"  PaddingSpec="0 0 0 0" 
            Lines="true"
            ColumnLines="true"
            Split="false"
            RowLines="true" 
            Anchor="100%"
            AutoScroll="true">
            <MessageBusListeners>
                <ext:MessageBusListener
                    AutoDataBind="true"
                    Name="MBL_RELOADOUTCOMES"
                    Handler="App.direct.UCOUTCOMES.ReloadTree();" />
            </MessageBusListeners>
            <Fields>
                <ext:ModelField Name="patient_id" />
                <ext:ModelField Name="pat_pw_id" />
                <ext:ModelField Name="pat_pw_event_id" />
                <ext:ModelField Name="pw_event_module_id" />
                <ext:ModelField Name="mid" />
                <ext:ModelField Name="module" HtmlEncode="true" Type="String" />
                <ext:ModelField Name="current_score_date" />
                <ext:ModelField Name="current_score" />
                <ext:ModelField Name="current_interpretation" />
                <ext:ModelField Name="current_status" />
                <ext:ModelField Name="current_reviewed" Type="Boolean" />
                <ext:ModelField Name="prev_score" />
                <ext:ModelField Name="prev_interpretation" />
                <ext:ModelField Name="current_status" />
                <ext:ModelField Name="current_status_id" />
                <ext:ModelField Name="current_severity" />
                <ext:ModelField Name="current_severity_id" />
                <ext:ModelField Name="event_status" />
                <ext:ModelField Name="intake_id" />
            </Fields>
            <ColumnModel>
                <Columns>
                    <ext:TreeColumn ID="colUCOM_module" DefaultButton="true"
                        runat="server"
                        Text="Instrument"
                        Flex="1"
                        Sortable="true"
                        DataIndex="module" >
                               <Renderer Handler="return Ext.util.Format.htmlDecode(value);" />
                        </ext:TreeColumn>

                    <ext:Column ID="colUCOM_current_interpretation"
                        runat="server"
                        Text="Interpretation"
                        Flex="1"
                        Sortable="true"
                        DataIndex="current_interpretation" />

                    <ext:Column ID="colUCOM_current_score"
                        runat="server"
                        Text="Current"
                        Width="70"
                        Sortable="true"
                        DataIndex="current_score" />

                    <ext:Column ID="colUCOM_prev_score"
                        runat="server"
                        Text="Previous"
                        Width="70"
                        Sortable="true"
                        DataIndex="prev_score" />

                    <ext:Column ID="colUCOM_current_status"
                        runat="server"
                        Text="Status"
                        Width="70"
                        Sortable="true"
                        DataIndex="current_status" />

                    
                    <ext:Column ID="Column1"
                        runat="server"
                        Text=""
                        Visible="false"
                        DataIndex="pat_pw_event_id" />

                    <ext:Column ID="Column2"
                        runat="server"
                        Text=""
                        Visible="false"
                        DataIndex="pat_pw_id" />

                    <ext:Column ID="Column3"
                        runat="server"
                        Text=""
                        Visible="false"
                        DataIndex="current_status_id" />

                    <ext:Column ID="Column4"
                        runat="server"
                        Text=""
                        Visible="false"
                        DataIndex="current_severity_id" />

                    <ext:Column ID="Column5"
                        runat="server"
                        Text=""
                        Visible="false"
                        DataIndex="current_severity" />

                </Columns>

            </ColumnModel>
            <Listeners>
            </Listeners>
            <BottomBar>
                <ext:Toolbar ID="tbMeasures" runat="server" TabIndex="35" Padding="0">
                <Items>
                    <ext:Button ID="btnMeasureReview" runat="server" Text="Review Outcome Measure" Icon="Pencil" >
                        <Listeners>
                            <AfterRender Handler="AriaOMReviewButton(App.btnMeasureReview.getEl());" ></AfterRender>
                            <Click Handler="OnUCOMReviewCommand('CMD_UCOM_REVIEW', App.tpnlUCOM.getSelectionModel().getSelection()[0].data );"></Click>
                        </Listeners>
                    </ext:Button>

                    <ext:Button ID="btnMeasureTrend" runat="server" Text="Trend Outcome Measure" Icon="ChartBar" >
                        <Listeners>
                            <AfterRender Handler="AriaOMTrendButton(App.btnMeasureTrend.getEl());" ></AfterRender>
                            <Click Handler="OnTrendCommand('CMD_SHOW_TREND', App.tpnlUCOM.getSelectionModel().getSelection()[0].data );"></Click>
                        </Listeners>
                    </ext:Button>
                </Items>
            </ext:Toolbar>
            </BottomBar>
            <SelectionModel>
                <ext:TreeSelectionModel ID="TreeSelectionModel1" EnableKeyNav="true" runat="server" Mode="Single">
                    <Listeners>
                        <Select Handler="App.direct.UCOUTCOMES.OnTreeSelect();"></Select>
                    </Listeners>
                    <CustomConfig>
                    </CustomConfig>
                </ext:TreeSelectionModel>
            </SelectionModel>
        </ext:TreePanel>

        

        <ext:Panel ID="pnlUCOMEventEntry"
            Margin="0"
            Region="Center"
            Split="true"
            Flex="1"
            Border="false"
            Anchor="100%"
            runat="server"
            Visible="true"
            Layout="AnchorLayout">
            <Content>
                <ucTBICDS:EventEntry ID="ucEventEntry" runat="server" />
            </Content>
        </ext:Panel>
    </Items>
</ext:Panel>
 


